-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema factura
--

-- CREATE DATABASE IF NOT EXISTS factura;
-- USE factura;

--
-- Definition of table `cliente`
--

DROP TABLE IF EXISTS `cliente`;
CREATE TABLE `cliente` (
  `idcliente` int(11) NOT NULL AUTO_INCREMENT,
  `Nif` varchar(12) NOT NULL,
  `NombreRazonSocial` varchar(120) NOT NULL,
  `Domicilio` varchar(100) NOT NULL,
  `RestoDomicilio` varchar(100) NOT NULL,
  `Email` varchar(100) NOT NULL,
  PRIMARY KEY (`idcliente`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `cliente`
--

/*!40000 ALTER TABLE `cliente` DISABLE KEYS */;
INSERT INTO `cliente` (`idcliente`,`Nif`,`NombreRazonSocial`,`Domicilio`,`RestoDomicilio`,`Email`) VALUES 
 (1,'00000003M','Cliente 1','C/ del Pino Verde, 1 áéíúó ñ','2045 Madrid','info@fhumanes.com'),
 (2,'00000002E','Cliente 2','Avda. de Gracia, 23','08001 Barcelona','info@fhumanes.com');
/*!40000 ALTER TABLE `cliente` ENABLE KEYS */;


--
-- Definition of table `factura`
--

DROP TABLE IF EXISTS `factura`;
CREATE TABLE `factura` (
  `idfactura` int(11) NOT NULL AUTO_INCREMENT,
  `cliente_idcliente` int(11) NOT NULL,
  `Nif` varchar(12) NOT NULL,
  `NombreRazonSocial` varchar(120) NOT NULL,
  `Domicilio` varchar(100) NOT NULL,
  `RestoDomicilio` varchar(100) NOT NULL,
  `FechaFactura` date NOT NULL,
  `TotalFactura` decimal(12,2) DEFAULT '0.00',
  `Email` varchar(100) NOT NULL,
  PRIMARY KEY (`idfactura`),
  KEY `fk_factura_cliente_idx` (`cliente_idcliente`),
  CONSTRAINT `fk_factura_cliente` FOREIGN KEY (`cliente_idcliente`) REFERENCES `cliente` (`idcliente`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `factura`
--

/*!40000 ALTER TABLE `factura` DISABLE KEYS */;
/*!40000 ALTER TABLE `factura` ENABLE KEYS */;


--
-- Definition of table `linea_factura`
--

DROP TABLE IF EXISTS `linea_factura`;
CREATE TABLE `linea_factura` (
  `idlinea_factura` int(11) NOT NULL AUTO_INCREMENT,
  `factura_idfactura` int(11) NOT NULL,
  `producto_idproducto` int(11) NOT NULL,
  `Nombre` varchar(50) NOT NULL,
  `Precio` decimal(12,2) NOT NULL,
  `Cantidad` int(11) NOT NULL,
  `Valor` decimal(12,2) NOT NULL,
  PRIMARY KEY (`idlinea_factura`),
  KEY `fk_linea_factura_factura1_idx` (`factura_idfactura`),
  KEY `fk_linea_factura_producto1_idx` (`producto_idproducto`),
  CONSTRAINT `fk_linea_factura_factura1` FOREIGN KEY (`factura_idfactura`) REFERENCES `factura` (`idfactura`) ON DELETE CASCADE ON UPDATE NO ACTION,
  CONSTRAINT `fk_linea_factura_producto1` FOREIGN KEY (`producto_idproducto`) REFERENCES `producto` (`idproducto`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `linea_factura`
--

/*!40000 ALTER TABLE `linea_factura` DISABLE KEYS */;
/*!40000 ALTER TABLE `linea_factura` ENABLE KEYS */;


--
-- Definition of table `producto`
--

DROP TABLE IF EXISTS `producto`;
CREATE TABLE `producto` (
  `idproducto` int(11) NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(50) NOT NULL,
  `Precio` decimal(12,2) NOT NULL,
  `Existencias` decimal(12,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`idproducto`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `producto`
--

/*!40000 ALTER TABLE `producto` DISABLE KEYS */;
INSERT INTO `producto` (`idproducto`,`Nombre`,`Precio`,`Existencias`) VALUES 
 (1,'Artículo 1','5.21','10.00'),
 (2,'Artículo 2','1.25','5.00'),
 (3,'Artículo 3','3.00','0.00'),
 (4,'Artículo 4','0.58','0.00'),
 (5,'Artículo 5','1.00','0.00');
/*!40000 ALTER TABLE `producto` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
